/* Compteur binaire:
Version française de Binary Counter
/*
/*Binary Counter
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 74HC595 shift register attached to pins 2, 3, and 4 of the Arduino,
 as detailed below.
 * 8 LEDs attached to each of the outputs of the shift register
 * 8 220 Ohm resistors
 
 Adapted from
 Shift Register Examples
 for 74HC595 shift register
 
 by Tom Igoe and Carlyn Maw  
 
Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 
 */

// La broche reliée à l’entrée LATCH (verrou) du 74HC595
int brocheVerrou = 8;
// La broche reliée à l’entrée CLOCK (horloge) du 74HC595
int brocheHorloge = 12;
// La broche reliée à l’entrée DATA (données) du 74HC595
int brocheDonnees = 11;
void setup() {
  // Déclaration en mode sortie des broches utilisées dans
  // la boucle principale
  pinMode(brocheVerrou, OUTPUT);
  pinMode(brocheDonnees, OUTPUT);
  pinMode(brocheHorloge, OUTPUT);
}

void loop() {
  // Boucle de 0 à 256
  int i;
  for(i=0; i<256; i++) {
    // Verrouillage au niveau bas des sorties du registre à
    // décalage afin que les LED soient éteintes lors de
    // l’envoi des données
    digitalWrite(brocheVerrou, LOW);
    shiftOut(brocheDonnees,brocheHorloge, LSBFIRST, i);
    // Déverrouillage des sorties du registre
    // afin que les LED s’allument :
    digitalWrite(brocheVerrou, HIGH);
    delay(300);
  }
}
